//QuickJava 0.4 by Doug Greene

//Version History
//Version 0.4.2 Changes: Updated installer for 1.5-3.0a1, fixed memory leak bug.
//Version 0.4.1 Changes: Updated Installer for FF1.5 support
//Version 0.4 Changes: Added middle click support
//Version 0.3 Changes: Added preference monitor service.
//Version 0.2 Changes: Updated graphics
//Version 0.1 Original Version

    var quickJava_prefs = Components.classes["@mozilla.org/preferences-service;1"].
        getService(Components.interfaces.nsIPrefBranch);
    var quickJavaScript_currentSet = quickJava_prefs.getBoolPref("javascript.enabled");
    var quickJava_currentSet = quickJava_prefs.getBoolPref("security.enable_java");


// When the Java Icon is clicked toggle the status
function onStatusBarJavaClick(event) {
  // event.button == 2 // right
  if (event.button == 0) {
	quickJava_toggle();
  }
  if (event.button == 1) {
	quickJava_toggle();
	quickJavaScript_toggle();
  }
  if (event.button != 0 && event.button != 1) {
	quickJava_updateIcons();
  }
	return true;
}

// When the JavaScript Icon is clicked toggle the status
function onStatusBarJavaScriptClick(event) {
  // event.button == 2 // right
  if (event.button == 0) {
	quickJavaScript_toggle();
  }
  if (event.button == 1) {
	quickJava_toggle();
	quickJavaScript_toggle();
  }
  if (event.button != 0 && event.button != 1) {
	quickJava_updateIcons();
  }

	return true;
}

// Update the icons after a slight delay (for on load)
function quickJava_updateIconsDelay()
{
    //Load the current settings
    quickJavaScript_currentSet = quickJava_prefs.getBoolPref("javascript.enabled");
    quickJava_currentSet = quickJava_prefs.getBoolPref("security.enable_java");
    //Set the icons
    setTimeout("setJavaIcon(quickJava_currentSet)",1250);
    setTimeout("setJavaScriptIcon(quickJavaScript_currentSet)",1250);
    return true;
}


// Update the icons 
function quickJava_updateIcons()
{
    //Load the current settings
    quickJavaScript_currentSet = quickJava_prefs.getBoolPref("javascript.enabled");
//alert(quickJavaScript_currentSet);
    quickJava_currentSet = quickJava_prefs.getBoolPref("security.enable_java");
//alert(quickJava_currentSet);
    //Set the icons
    setJavaIcon(quickJava_currentSet);
    setJavaScriptIcon(quickJavaScript_currentSet);
//    alert("Java icon = " + quickJava_currentSet + "\nJavaScript icon = " + quickJavaScript_currentSet);
    return true;
}

function quickJava_toggle()
{
	quickJava_setOnOff(!quickJava_currentSet);
}

function quickJavaScript_toggle()
{
	quickJavaScript_setOnOff(!quickJavaScript_currentSet);
}

function quickJava_setOnOff(onOff)
{
	quickJava_prefs.setBoolPref("security.enable_java", onOff);
	setJavaIcon(onOff);
	quickJava_currentSet = onOff;
}

function quickJavaScript_setOnOff(onOff)
{
	quickJava_prefs.setBoolPref("javascript.enabled", onOff);
	setJavaScriptIcon(onOff);
	quickJavaScript_currentSet = onOff;
}

function setJavaIcon(onOff) {
	if (!window.statusbar.visible)
		return;
  document.getElementById('quickJava-status').setAttribute("status", onOff ? "1" : "0");
}

function setJavaScriptIcon(onOff) {
	if (!window.statusbar.visible)
		return;
  document.getElementById('quickJavaScript-status').setAttribute("status", onOff ? "1" : "0");
}

var myPrefObserver =
{
  register: function()
  {
    var observingPrefsActive = false;
    var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                                .getService(Components.interfaces.nsIPrefBranchInternal);
    this._branch = prefService.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
    this._branch.addObserver("", this, false);
    quickJava_updateIcons();
  },

  unregister: function()
  {
    if(!this._branch) return;
    this._branch.removeObserver("", this);
  },

  observe: function(aSubject, aTopic, aData)
  {
    if(aTopic != "nsPref:changed") return;
    // aSubject is the nsIPrefBranch we're observing
    // aData is the name of the pref that's been changed (relative to aSubject)
    switch (aData) {
      case "javascript.enabled":
        // javascript.enabled was changed
	  quickJava_updateIcons();
        break;
      case "security.enable_java":
        // security.enable_java was changed
	  quickJava_updateIcons();
        break;
    }
  }
}

window.addEventListener('load',evtLoad,false);
window.addEventListener('unload',evtUnload,false);

function evtLoad(evt)
{
   myPrefObserver.register();
}

function evtUnload(evt)
{
   myPrefObserver.unregister();
}
